<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Quotation</title>
	{{ HTML::style('css/bootstrap.css') }}
<style>
  body { font-family: "Helvetica Neue", Helvetica, Arial, sans-serif; }
	/* Print Only */
	@media print{
			.print-container{width: 100% !important;margin: 0;}
			@page {size: A5;margin: 0;}
		header.sale-v2-header .logo img {width: 100px;padding: 0;}
	}
	body { font-size: 12px; }
  .font-kh { font-family: "Khmer OS Fasthand"; }
	.invoice-address h2 { font-size: 18px; font-weight: bold; color: blue; margin-bottom: 5px;}
	.invoice-address h3 { font-size: 16px; font-weight: bold; color: red; margin-top: 0; margin-bottom: 0;}
	table, td, th {border: 1px solid #000;text-align: left;}
	hr { border: 0 !important;}
	table {border-collapse: collapse; width: 100%;}
	th { font-weight: bold !important; padding: 5px;}
	td { padding: 0px; padding-left: 5px; padding-right: 5px; color: #000 !important;  vertical-align: top;}
	th { font-weight: normal; font-size: 12px;}
	.buyer, .seller { position: absolute; bottom: 70px; }
	.buyer { left: 10px;}
	.seller { right: 10px;}
	.date { position: absolute; bottom: 90px; right: 10px;}
	.border { border: 0; border-bottom: 2px solid #080808;margin-bottom: 0 !important;padding-bottom: 5px;}
	.detail { font-size: 14px; }
	table.no-border th, .no-border td {border: 0 !important;padding: 2px !important;}
		footer p { padding: 0 !important;margin-bottom: 0 !important;}
		li { font-size: 12px; }
		.ruler {border: 0; border-bottom: 1px solid #080808; margin-bottom: 0 !important; padding-bottom: 10px; position: absolute;width: 100%;bottom: 65px;left: 0;}
		p.sign {
			border-top: 1px solid #000 !important;
			padding-top: 5px !important;
			color: blue;
		}
		.content { min-height: 360px !important; }
		.content td { border: 0; border-right: 1px solid #000; }
		.invoice-address p { margin-bottom: 0; color: green; }
		footer { padding-top: 20px; }
		.term, .term ul li{ font-size: 8px; }
		.term ul { padding-left: 10px; }
		.term ul li { list-style-type: circle;}
		.total th, .total tr { font-size: 11px !important; font-weight: bold !important;  text-align: right !important;}
	</style>
</head>
<script>
	window.print();
</script>
<body>
	<div class="container invoice-v2 print-container">
		<div class="row">
			<div class="col-xs-3">
				<header class="sale-v2-header">
				<div class="logo pull-left">
					{{ HTML::image('uploads/network.jpg', "Network Computer Shop", [
							'width' => '100px',
							'style' => "padding-top: 10px;"
					]) }}
				</div>
				</header>
			</div>
			<div class="col-xs-9">
				<div class="invoice-address">
					<hgroup>
						<h2>{{ get_config('company_name') }}</h2>
						<h3>Network Computer Center</h3>
					</hgroup>
					{{ get_config('company_address') }}
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<p class="text-center detail border font-kh">{{ get_config('company_detail') }}</p>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-6">
				<table class="no-border" style="margin-top: 5px; border:1px solid #000;">
					<tr>
						<td colspan="2" style="font-size: 14px;"><b>{{ trans('invoices.sold_to') }} / Sold to:</b></td>
					</tr>
					<tr>
						<th style="width: 100px;"">{{ trans('customers.menu') }}</th>
						@if ($invoice->customer_id)
							<td>{{ $invoice->first_name }} {{ $invoice->last_name }}</td>
						@else
							<td>: General Customer</td>
						@endif
					</tr>
					<tr>
						<th>Tel</th>
						<td>: {{ $invoice->tel }}</td>
					</tr>
					<tr>
						<th>Address</th>
						<td>: {{ $invoice->address }}</td>
					</tr>
				</table>
			</div>
			<div class="col-xs-6">
				<h3 class='text-right' style="margin-top: 5px; margin-bottom: 0; font-size: 18px; text-decoration: underline; font-style: italic; color: blue;">INVOICE</h3>
				<table class="no-border" style="border: 0px;">
					<tr>
						<td>{{ trans('invoices.in_no') }} / N<sup>o</sup></td>
						<td>: {{ convertInvoiceNumber($invoice->id) }}</td>
					</tr>
					<tr>
						<td>{{ trans('invoices.date') }} / Date</td>
						<td>: {{ $invoice->created_at }}</td>
					</tr>
					<tr>
						<td>{{ trans('invoices.saler') }} / Saler</td>
						<td>: {{ $invoice->funame }} {{ $invoice->luname }}</td>
					</tr>
				</table>
				<table class="no-border">
					<td style="background-color: #ddd; font-style: italic; text-align: center;">{{ get_config("invoice_client_note") }}</td>
				</table>
			</div>
		</div>
		<br>
		<div class="row">
			<div class="col-xs-12 content">
						<table>
						<thead>
							<tr>
								<th style="width: 5%;">N<sup>o<sup></th>
								<th>Item Code</th>
								<th>Description</th>
								<th>Qty</th>
								<th style="width: 15%;">Price</th>
								<th style="width: 15%;">Amount</th>
							</tr>
						</thead>
						<tbody>
						@if (count($orders) > 0)
							<?php 
								$total = 0;
								$i = 1;
							 ?>
							@foreach ($orders as $order)
							<?php $total += $order->amount * $order->price; ?>
							<tr>
								<td>{{ $i; }}</td>
								<td>{{ $order->sku }}</td>
								<td>{{ $order->name }}</td>
								<td>{{ $order->amount }}</td>
								<td>{{ money($order->price) }}</td>
								<td>{{ money($order->amount * $order->price) }}</td>
							</tr>
							<?php $i++; ?>
							@endforeach
						@endif
						</tbody>
					</table>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-7">
					<div class="row">
						<div class="col-xs-12 term"​>
							{{ get_config('invoice_payment_term') }}
						</div>
						<div class="col-xs-3" style="font-size: 9px; color: red;">
							Payment term check 
						</div>
						<div class="col-xs-9" style="font-size: 9px; color: green;">
						  {{ get_config('invoice_footer') }}
						</div>
					</div>
			</div>
			<div class="col-xs-5">
				<table class="no-border total" style="border: 0;">
					<tr>
						<th style="width:50%;">{{ trans('invoices.total_riel') }} / RIEL:</th>
						<td class="text-right">{{ money($invoice->total * get_config('invoice_rate'), gscc()) }}</td>
					</tr>
					<tr>
						<th>{{ trans('invoices.total_usd') }} / USD:</th>
						<td class="text-right">{{ money($invoice->total) }}</td>
					</tr>
					<tr>
						<th>{{ trans('invoices.pay_1') }} / PAY:</th>
						<td class="text-right">{{ money($invoice->recieved) }}</td>
					</tr>
					<tr>
						<th>{{ trans('invoices.bal') }} / BAL:</th>
						<td class="text-right">{{ money($invoice->deposit) }}</td>
					</tr>
				</table>
			</div>
		</div>	
		<footer>
			<div class="row" style="padding-top: 20px;">
				<div class="col-xs-4">
					<p class="text-center sign">{{ trans('customers.menu') }} / Customer</p>
				</div>
				<div class="col-xs-4">
					<p class="text-center sign">{{ trans('invoices.reveiver') }} / Reveiver</p>
				</div>
				<div class="col-xs-4">
					<p class="text-center sign">{{ trans('invoices.saler') }} / Saler</p>
				</div>
			</div>
		</footer>
	</div>
	@if(get_config('turn_off_print_dialog') == "yes")
		<script type="text/javascript">
		  window.close();
		</script>
	@endif
</body>
</html>